﻿using AZVIC.Ei8htPOS.Entities;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization.Formatters.Binary;
using System.Text;
using System.Threading.Tasks;

namespace AZVIC.Ei8htPOS.POSFB.Helpers
{
    public static class LayoutHelper
    {
        public static void SaveLayout(List<Layout> Layouts)
        {
            using (MemoryStream ms = new MemoryStream())
            {
                BinaryFormatter bf = new BinaryFormatter();
                bf.Serialize(ms, Layouts);
                ms.Position = 0;
                byte[] buffer = new byte[(int)ms.Length];
                ms.Read(buffer, 0, buffer.Length);
                Properties.Settings.Default.TableLayoutList = Convert.ToBase64String(buffer);
                Properties.Settings.Default.Save();
            }
        }

        public static List<Layout> LoadLayout()
        {
            if (!string.IsNullOrEmpty(Properties.Settings.Default.TableLayoutList))
            {
                using (MemoryStream ms = new MemoryStream(Convert.FromBase64String(Properties.Settings.Default.TableLayoutList)))
                {
                    BinaryFormatter bf = new BinaryFormatter();
                    return (List<Layout>)bf.Deserialize(ms);
                }
            }
            else
            {
                return null;
            }
        }
    }
}
